using System;
using System.Data;
using System.Data.SqlClient;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{

	#region Header

	//<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	//<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	//<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	//<Developers>
	//	<Developer>Stas Antropov</Developer>
	//</Developers>
	//<SiteName>Hines OIFO</SiteName>
	//<CreationDate>6/1/2004</CreationDate>
	//<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	//<summary>
	// Provides data access functionality for time zones. Retrieves time zone
	// data from the VBECS database.
	//</summary>

	#endregion

	/// <summary>
	/// Provides data access functionality for time zones. Retrieves time zone
	/// data from the VBECS database.
	/// </summary>
	public class TimeZone
	{
		private TimeZone() {}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/8/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4682"> 
		///		<ExpectedInput>None.</ExpectedInput>
		///		<ExpectedOutput>Non-empty list of time zones.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4683"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves all time zones stored in VBECS database, 
		/// one <see cref="DataRow"/> per time zone.
		/// </summary>
		/// <returns>
		///		<see cref="DataTable"/> containing data for all time 
		///		zones stored in the VBECS database.
		///	</returns>
		public static DataTable GetAll()
		{
			return Common.StoredProcedure.GetDataTable( STOREDPROC.GetTimeZoneList.StoredProcName );
		}

		///<Developers>
		///	<Developer>Stas Antropov</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4684"> 
		///		<ExpectedInput>Valid time zone ID char.</ExpectedInput>
		///		<ExpectedOutput>An instance of the class.</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4685"> 
		///		<ExpectedInput>Non-existent time zone ID.</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayerException.</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Retrieves a single <see cref="DataRow"/> containing data 
		/// for a single time zone with a given ID.
		/// </summary>
		/// <param name="timeZoneID">Time zone ID.</param>
		/// <returns><see cref="DataRow"/> containing data for a time zone with a given ID.</returns>
		public static DataRow GetByID( char timeZoneID )
		{
			return ReferenceData.GetTimeZone( Char.ToUpper( timeZoneID ).ToString() );
		}
	}
}
